
var exportResult = null; // result of the current html export
var currSpread = -1; // the spread we are currently previewing
var currPages = -1; // the pages set within the spread being previewed
var masterAlertBoxTitleStr = ""; // Title for master spread alert dialog
var masterAlertMsgStr = ""; // Master spread alert message
var masterAlertOKButtonLabelStr = ""; // Master spread alert OK button label
var pageTipStr = ""; // For page range tip

function getFrameSrcDoc(fr) {
    return fr.contentDocument || fr.contentWindow.document;
}

function onLoaded()
{
    var csInterface = new CSInterface();

    loadJSX();
    
    updateThemeWithAppSkinInfo(csInterface.hostEnvironment.appSkinInfo);

    // Update the color of the panel when the theme color of the product changed.
    csInterface.addEventListener(CSInterface.THEME_COLOR_CHANGED_EVENT, onAppThemeColorChanged);

    // Set the default preview option to be spread, if there is no other option selected.
    if($("#spreadButton").hasClass("selectedButton") == false && $("#documentButton").hasClass("selectedButton") == false)
    {
        $("#spreadButton").removeClass("unselectedButton");
        $("#spreadButton").addClass("selectedButton");
    }

    var extScript = "$._ext_IDSN.getNumOpenDocuments()";
    evalScript(extScript, function(result)
    {
        var result1 = JSON.parse(result);
        // Disable the preview button only if there are no open documents.
        if(result1.count == 0)
            $("#previewButton").addClass("disabledButton");

        $("#stopButton").addClass("disabledButton");
        $("#previousButton").addClass("disabledButton");
        $("#nextButton").addClass("disabledButton");
    });
    
    // Add an event listener to listen to new document creation
    csInterface.addEventListener("documentAfterActivate", onDocumentActivated); 
    csInterface.addEventListener("documentAfterDeactivate", onDocumentDeactivated);

    // Add an event listener to listen to Preview event requests
    csInterface.addEventListener("com.adobe.indesign.events.DoSpreadPreview", onSpreadPreivew);
    csInterface.addEventListener("com.adobe.indesign.events.DoDocumentPreview", onDocumentPreview);
    
    $("button").hover(
      function() {
        if($(this).hasClass("disabledButton") == false && $(this).hasClass("selectedButton") == false) {
            $(this).removeClass("unselectedButton");
            $(this).addClass("rolloverButton");
        }

        if($(this).hasClass("disabledButton")) {
            if(csInterface.getScaleFactor() > 1.4 &&   // HiDpi
                navigator.platform.indexOf("Mac") < 0) // Windows only
                $(this).addClass("no-opCursor2x");
            else
                $(this).addClass("no-opCursor1x");
        }
      },
      function() {
        if($(this).hasClass("selectedButton") == false) {
            $(this).removeClass("rolloverButton");
            $(this).addClass("unselectedButton");
        }

        if($(this).hasClass("disabledButton")) {
            if(csInterface.getScaleFactor() > 1.4 &&   // HiDpi
                navigator.platform.indexOf("Mac") < 0) // Windows only    
                $(this).removeClass("no-opCursor2x");            
            else
                $(this).removeClass("no-opCursor1x");
        }
      }
    );
    
    // Disable drop inside the panel
    window.ondragenter = function(event) { event.dataTransfer.dropEffect = 'none'; event.stopPropagation(); event.preventDefault(); };
    window.ondragover = function(event) { event.dataTransfer.dropEffect = 'none'; event.stopPropagation(); event.preventDefault(); };
    window.ondrop = function(event) { event.dataTransfer.dropEffect = 'none'; event.stopPropagation(); event.preventDefault(); };

    // Initialize locale resources
    var resourceBundle = csInterface.initResourceBundle();
    masterAlertBoxTitleStr = resourceBundle["HTMLPreviewPanelName"];
    masterAlertMsgStr = resourceBundle["MasterAlertMsg"];
    masterAlertOKButtonLabelStr = resourceBundle["OKButtonLabel"];
    pageTipStr = resourceBundle["PageStr"];

    if(navigator.platform.indexOf("Mac") < 0) // Windows
    {
        // Remove the javascript based ctooltip on windows
        $("#previewButton").removeClass("ctooltip");
        $("#stopButton").removeClass("ctooltip");
        $("#previousButton").removeClass("ctooltip");
        $("#nextButton").removeClass("ctooltip");
        $("#documentButton").removeClass("ctooltip");
        $("#spreadButton").removeClass("ctooltip");
        $("#pageNumberWrapper").removeClass("ctooltip");

        // Set the tooltips for buttons
        $("#previewButton").attr("title", resourceBundle["PlayButtonTipWin"]);
        $("#stopButton").attr("title", resourceBundle["StopButtonTip"]);
        $("#previousButton").attr("title", resourceBundle["PreviousButtonTip"]);
        $("#nextButton").attr("title", resourceBundle["NextButtonTip"]);
        $("#documentButton").attr("title", resourceBundle["DocumentButtonTip"]);
        $("#spreadButton").attr("title", resourceBundle["SpreadButtonTip"]);
    }
    else // Mac
    {
        $("#previewButtonctooltip").html(resourceBundle["PlayButtonTipMac"]);
        $("#stopButtonctooltip").html(resourceBundle["StopButtonTip"]);
        $("#previousButtonctooltip").html(resourceBundle["PreviousButtonTip"]);
        $("#nextButtonctooltip").html(resourceBundle["NextButtonTip"]);
        $("#documentButtonctooltip").html(resourceBundle["DocumentButtonTip"]);
        $("#spreadButtonctooltip").html(resourceBundle["SpreadButtonTip"]);
        $("#pageNumberWrapper").removeClass("ctooltip");
    }

    // Notify InDesign that the extension has been loaded.
    // While the CEP framework does send a generic event upon extension load (csxs::event::EVENT_TYPE_CSXS_EXTENSION_LOADED), we send an
    // extension specific event here, when we are loaded completely (more specifically, after we have registered a listener for our
    // spread-preview event - com.adobe.indesign.events.DoSpreadPreview).
    // Since the CEP extension-loaded event is sent before onLoaded() gets executed, our listener otherwise would not be in place when InDesign
    // sends the spread-preview event (for auto load) in response to extension load event.
    var csInterface = new CSInterface();
    var event = new CSEvent("HTMLPreview", "APPLICATION");
    event.data = "ExtensionLoaded";
    event.extensionId = csInterface.getExtensionID();    
    csInterface.dispatchEvent(event);


    // Keep the iframe hidden to start with
    $("#previewFrame").hide();    
}

function pageRangeMatch(newRange, currRange)
{
    if(currRange == newRange)
    {
        return true;
    }
    else if(newRange.indexOf("-") <= -1) // Single page number
    {
        var pages = currRange.split("-");
        var i;
        for(i = 0; i<pages.length; i++)
        {
            if(newRange == pages[i])
            {
                return true;
            }
        }
    }    
    return false;
}

function onManualPageNumberEntry() {
    if(currSpread == -1 || currPages == -1)
        return;
    // Get the input
    var newPageRange = $("#pageNumber").val();
    currPageRangeStr = exportResult.spreads[currSpread][currPages].pageRange;

   if(pageRangeMatch(newPageRange, currPageRangeStr))
   {
        // matches the current page range
        updatePreviewPanel(false);        
        return;
   }
   

    // Iterate over all the spreads to see if the page-range-string matches
    var s,p;    
    for(s=0; s < exportResult.spreads.length; s++ )
        for(p=0; p < exportResult.spreads[s].length; p++){
            currPageRangeStr = exportResult.spreads[s][p].pageRange;
            if(pageRangeMatch(newPageRange, currPageRangeStr)){
                currSpread = s;
                currPages = p; 
                // Load the new spread
                updatePreviewPanel(true);
                LogUIEvent("EditBoxValidInput");
                return;
            }
        }
    
    // Invalid input. Restore the panel to previous state.
    updatePreviewPanel(false);
    LogUIEvent("EditBoxInvalidInput");
}

function onKeyDown(event)
{
    if("pageNumber" == document.activeElement.id)
    {  
        if(event.keyCode == 13)
        {
            onManualPageNumberEntry();
            $("#pageNumber").blur();
        }        
        // Let the keys work if editing the page number box.
        return;
    }
    if(event.keyCode == 8 || event.keyCode == 46)
    {
        // Prevent backspace/delete from navigating to previous contents.
        event.preventDefault();
        event.stopPropagation();
    }
}

function onResize()
{
    if(currSpread == -1 || currPages == -1)
        return;

    var spreadData = exportResult.spreads[currSpread];
    var pageData = spreadData[currPages];

    var contentWidth = pageData.contentWidth;
    var contentHeight = pageData.contentHeight;

    // Handles resizing the iframe.
    // Center the iframe in the parent container div, and scale to fit.
    var containerWidth = $("#previewFrameContainer").width();
    var containerHeight = $("#previewFrameContainer").height();

    // The iframe size is set to its content size, and then centered in the container div,
    // also making use of the left/top: 50% attributes applied through CSS.
    var frame = document.getElementById("previewFrame");
    frame.width = contentWidth + "px";
    frame.height = contentHeight + "px";
    frame.style.margin = (-contentHeight / 2) + "px" + " 0 0 " + (-contentWidth / 2) + "px";

    // Scaling follows.
    var scaleX = containerWidth / contentWidth;
    var scaleY = containerHeight / contentHeight;
    var scale = scaleX;
    if(scaleX > scaleY)
        scale = scaleY;

    var transformString = "scale(" + scale + ")translateZ(0px)";
    frame.style["-webkit-transform-origin"] = "50% 50%";
    frame.style["-webkit-transform"] = transformString;
}

function isPreviewFile(url)
{
    // Check if the url is one of the preview files.
    var result = {};
    result.spread = -1;
    result.pages = -1;

    // Get the file part for comparison.
    url = url.substring(url.lastIndexOf('/') + 1);
    if(url == "")
        return result;

    var spread, pages;
    for(spread = 0; spread < exportResult.spreads.length; spread++) {

        var spreadData = exportResult.spreads[spread];
        for(pages = 0; pages < spreadData.length; pages++) {

            if(url == spreadData[pages].exportFileName) {
                result.spread = spread;
                result.pages = pages;
                return result;
            }
        }
    }
    return result;
}

function onFrameDOMLoaded()
{
    // Special handling for iframe to disable context menu, and drag/drop (both source and target)
    // This works since both outer html and iframe serve content on the same domain - localhost in this case.
    var frame = window.frames["previewFrame"];    
    getFrameSrcDoc(frame).oncontextmenu = function() { return false; };
    getFrameSrcDoc(frame).ondragstart = function() { return false; };

    getFrameSrcDoc(frame).ondragenter = function(event) { event.dataTransfer.dropEffect = 'none'; event.stopPropagation(); event.preventDefault(); };
    getFrameSrcDoc(frame).ondragover = function(event) { event.dataTransfer.dropEffect = 'none'; event.stopPropagation(); event.preventDefault(); };
    getFrameSrcDoc(frame).ondrop = function(event) { event.dataTransfer.dropEffect = 'none'; event.stopPropagation(); event.preventDefault(); };
    getFrameSrcDoc(frame).onkeydown = function(event) { onKeyDown(event); };

    // Intercept all clicks on the links in iframe. 
    // External links to be opened in browser    
    $('a', getFrameSrcDoc(frame)).on('click', function(event) {
                                            var url = event.currentTarget.href;
                                            var result = isPreviewFile(url);
                                            if(result.spread == -1 || result.pages == -1) {
                                                handleExternalLink(url);
                                            }
                                            else {
                                                if(shouldNavigate(result)) {
                                                    event.currentTarget.trigger('click');
                                                }
                                            }
                                            return false;
                                        });

    $("#previewFrame").show();
}

function handleExternalLink(url)
{
    // Open external links in browser
    window.cep.util.openURLInDefaultBrowser(url);
}

function shouldNavigate(result)
{
    // Update the page range before navigation
    if(currSpread != result.spread || currPages != result.pages) {
        currSpread = result.spread;
        currPages = result.pages;
        updatePreviewPanel(false);
        return true;
    }
    else {
        return false;
    }
}

/**
 * Update the theme with the AppSkinInfo retrieved from the host product.
 */
function updateThemeWithAppSkinInfo(appSkinInfo)
{
    var panelBackgroundColor = appSkinInfo.panelBackgroundColor.color;
    document.body.bgColor = toHex(panelBackgroundColor);
   
    $("#buttonDiv").css("background-color", toHex(panelBackgroundColor));

    var styleId = "ppstyle";
      
    if(panelBackgroundColor.red > 127)
        $("#theme").attr("href","./lightTheme.css");
    else
        $("#theme").attr("href","./darkTheme.css");

    addRule(styleId, ".default", "font-size:" + appSkinInfo.baseFontSize + "px" + "; color:" + reverseColor(panelBackgroundColor) + "; background-color:" + toHex(panelBackgroundColor, 20));
    addRule(styleId, "button", "border-color: " + toHex(panelBackgroundColor, -50));
}

function addRule(stylesheetId, selector, rule) {
    var stylesheet = document.getElementById(stylesheetId);

    if(stylesheet) {
        stylesheet = stylesheet.sheet;
        if( stylesheet.addRule ){
            stylesheet.addRule(selector, rule);
        } else if( stylesheet.insertRule ){
            stylesheet.insertRule(selector + ' { ' + rule + ' }', stylesheet.cssRules.length);
        }
    }
}

function reverseColor(color, delta) {
    return toHex({red:Math.abs(255-color.red), green:Math.abs(255-color.green), blue:Math.abs(255-color.blue)}, delta);
}

/**
 * Convert the Color object to string in hexadecimal format;
 */
function toHex(color, delta) {
    function computeValue(value, delta) {
        var computedValue = !isNaN(delta) ? value + delta : value;
        if(computedValue < 0) {
            computedValue = 0;
        } else if(computedValue > 255) {
            computedValue = 255;
        }

        computedValue = computedValue.toString(16);
        return computedValue.length == 1 ? "0" + computedValue : computedValue;
    }

    var hex = "";
    if(color) {
        with(color) {
            hex = computeValue(Math.ceil(red), delta) + computeValue(Math.ceil(green), delta) + computeValue(Math.ceil(blue), delta);
        };
    }
    return "#" + hex;
}

function onAppThemeColorChanged(event) {
    // Should get a latest HostEnvironment object from application.
    var skinInfo = JSON.parse(window.__adobe_cep__.getHostEnvironment()).appSkinInfo;
    // Gets the style information such as color info from the skinInfo, 
    // and redraw all UI controls of your extension according to the style info.
    updateThemeWithAppSkinInfo(skinInfo);
}

function initializePanelButtons() {
    var extScript = "$._ext_IDSN.getNumOpenDocuments()";
    evalScript(extScript, function (result) {
        var result1 = JSON.parse(result);
        if (result1.count == 0)
            $("#previewButton").addClass("disabledButton");
    });

    $("#stopButton").addClass("disabledButton");
    $("#previousButton").addClass("disabledButton");
    $("#nextButton").addClass("disabledButton");
    $("#pageNumber").val("");

    if(navigator.platform.indexOf("Mac") < 0) // Windows
        $("#pageNumber").attr("title", ""); 
    else
        $("#pageNumberWrapper").removeClass("ctooltip");
    
    setFrameSrc("");
}

function onDocumentDeactivated() {
    enableDisablePageNumberBox(false);
    initializePanelButtons();
}

function onDocumentActivated(event) {
    // Make the preview button enabled, and the rest disabled.    
    $("#previewButton").removeClass("disabledButton");

    $("#stopButton").addClass("disabledButton");
    $("#previousButton").addClass("disabledButton");
    $("#nextButton").addClass("disabledButton");
    $("#pageNumber").val("");

    if(navigator.platform.indexOf("Mac") < 0) // Windows
        $("#pageNumber").attr("title", ""); 
    else
        $("#pageNumberWrapper").removeClass("ctooltip");

    setFrameSrc("");
} 
    
function onSpreadPreivew() {
    // If not already in spread preview mode, switch.
    onClickSpreadButton();
    onClickPreviewButtonInner(true);
}
    
function onDocumentPreview() {
    // If not already in document preview mode, switch.
    onClickDocumentButton();
    onClickPreviewButtonInner(true);
}
    
/**
 * Load JSX file into the scripting context of the product. All the jsx files in 
 * folder [ExtensionRoot]/jsx will be loaded. 
 */
function loadJSX() {
    var csInterface = new CSInterface();
    var extensionRoot = csInterface.getSystemPath(SystemPath.EXTENSION) + "/jsx/";
    csInterface.evalScript('$._ext.evalFiles("' + extensionRoot + '")');
}

function evalScript(script, callback) {
    new CSInterface().evalScript(script, callback);
}

function setFrameSrc(src) {
    $("#previewFrame").attr("src", src);
    if(src == "")
        $("#previewFrame").hide();
}

function updatePreviewPanel(updateFrame) {

    if(currSpread == -1 || currPages == -1)
        return;

    if(updateFrame) {
        // Update the iframe to possible new content size.
        setFrameSrc("");
        onResize();
    }
    else {
        onResize();
    }

    var spreadData = exportResult.spreads[currSpread];
    var pageData = spreadData[currPages];

    if(updateFrame) {
        // Update iframe contents.
        // We use a slight delay here so that the resizing changes sink in, otherwise the
        // new contents show up with the iframe still the old size.
        setTimeout(function () {
            setFrameSrc(pageData.exportFilePath);
        }, 100);
    }

    // Enable stop button.
    $("#stopButton").removeClass("disabledButton");

    // Update page range.
    var pageRangeStr = pageData.pageRange;
    if(pageRangeStr.length > 15)
        pageRangeStr = pageRangeStr.substring(0, 12) + "...";
    $("#pageNumber").val(pageRangeStr);    

    var pageRangeTip = exportResult.docName;
    var lastPeriodIndex = pageRangeTip.lastIndexOf('.');
    if(lastPeriodIndex > 1)
        pageRangeTip = pageRangeTip.substring(0, lastPeriodIndex);
    pageRangeTip += ": " + pageTipStr + " " + pageData.pageRange;

    // page range tooltip
    if(navigator.platform.indexOf("Mac") < 0) // Windows
        $("#pageNumber").attr("title", pageRangeTip); 
    else{
        $("#pageNumberWrapper").addClass("ctooltip");
        $("#editBoxTooltip").html(pageRangeTip);
    }

    // Update navigation buttons.
    $("#previousButton").removeClass("disabledButton");
    $("#nextButton").removeClass("disabledButton");

    if(currSpread == 0 && currPages == 0) {
        $("#previousButton").addClass("disabledButton");
        $("#previousButton").removeClass("rolloverButton");
        $("#previousButton").addClass("unselectedButton");
    }
    if(currSpread == exportResult.spreads.length - 1 && currPages == spreadData.length - 1) {
        $("#nextButton").addClass("disabledButton");
        $("#nextButton").removeClass("rolloverButton");
        $("#nextButton").addClass("unselectedButton");
    }
}

function doThePreview(previewSpread) {
    // Cleanup old preview files.
    var extScript = "$._ext_IDSN.deletePreviewFiles(false)";
    evalScript(extScript, null);
    enableDisablePageNumberBox(false);

    // Export the active layout spread or document to html.
    if(previewSpread)
        extScript = "$._ext_IDSN.exportActiveSpread()";
    else
        extScript = "$._ext_IDSN.exportActiveDocument()";
    evalScript(extScript, function(result) {
        exportResult = JSON.parse(result);
        if(exportResult.status) {
            currSpread = 0;
            currPages = 0;
            updatePreviewPanel(true); // Update the preview
            if(!previewSpread){
                enableDisablePageNumberBox(true);
                $("#pageNumber").focus();
            }
            LogPreview(previewSpread, true);
        }
        else {
            // Export failed. Reset the panel
            // Enable stop button.
            $("#stopButton").removeClass("disabledButton");
            LogPreview(previewSpread, false);
            ResetPreview();
        }
    });
}

function onClickPreviewButtonInner(canDoMasterSpreadAlert) {
    if($("#spreadButton").hasClass("selectedButton")) {
        // Spread mode.
        // Check if the active spread is a master.
        var extScript = "$._ext_IDSN.isActiveSpreadMaster()";
        evalScript(extScript, function(result) {
            var result1 = JSON.parse(result);
            if(result1.isMaster) {
                if(!canDoMasterSpreadAlert)
                    return;

                // Show the master spread alert.
                extScript = "$._ext_IDSN.doMasterSpreadAlertBox('";
                extScript += masterAlertBoxTitleStr + "'";
                extScript += ',' + "'" + masterAlertMsgStr + "'";
                extScript += ',' + "'" + masterAlertOKButtonLabelStr + "')";
                evalScript(extScript, null);
            }
            else {
                doThePreview(true);
            }
        });
    }
    else {
        // Document mode.
        doThePreview(false); // $("#documentButton").hasClass("selectedButton")
    }
}


function onClickPreviewButton(evt) {
    if($("#previewButton").hasClass("disabledButton"))
        return;

    // Reload on Alt-click.
    if(evt.altKey) {
        // If preview is already available, use it, else we need to regenerate.
        // Re-start with the first exported html file.
        if(currSpread != -1 && currPages != -1) {
            if(currSpread == 0 && currPages == 0) {
                // Already on the first exported html, just reload.
                var frame = window.frames["previewFrame"];                
                getFrameSrcDoc(frame).location.reload();
            }
            else {
                currSpread = 0;
                currPages = 0;
                updatePreviewPanel(true); // Update the preview
            }
            LogUIEvent("PreviewButtonReload");
            return;
        }
    }
    else
    {
        LogUIEvent("PreviewButton");
    }

    onClickPreviewButtonInner(true); // canDoMasterSpreadAlert = true
}

function exportNextOrPreviousSpread(previousSpread) {
    if(currSpread == -1 || currPages == -1)
        return;

    var spreadData = exportResult.spreads[currSpread];
    if(previousSpread) {
        if(currSpread == 0 && currPages == 0)
            return;
        currPages--;
        if(currPages == -1) {
            currSpread--;
            spreadData = exportResult.spreads[currSpread];
            currPages = spreadData.length - 1;
        }
    }
    else {
        if(currSpread == exportResult.spreads.length - 1 && currPages == spreadData.length - 1)
            return;
        currPages++;
        if(currPages == spreadData.length) {
            currSpread++;
            currPages = 0;
        }
    }

    // Update the panel.
    updatePreviewPanel(true);
}

function onClickStopButton() {
    if($("#stopButton").hasClass("disabledButton") == false) {
        ResetPreview();    
        LogUIEvent("StopButton");
    }    
}

function ResetPreview() {    
        initializePanelButtons();
        $("#stopButton").addClass("rolloverButton");

        exportResult = null;
        currSpread = -1;
        currPages = -1;

        var extScript = "$._ext_IDSN.deletePreviewFiles(true)"; // cleanup preview files and export folder
        evalScript(extScript, null);
        enableDisablePageNumberBox(false);
    }

function onClickPreviousButton() {
    if($("#previousButton").hasClass("disabledButton") == false){        
        exportNextOrPreviousSpread(true); 
        LogUIEvent("PreviousButton");
    }

}

function onClickNextButton() {
    if($("#nextButton").hasClass("disabledButton") == false){
        exportNextOrPreviousSpread(false);
        LogUIEvent("NextButton");
}
}

function deselectButton(buttonID) {
    var btnID = "#" + buttonID;
    if ($(btnID).hasClass("selectedButton")) {
        $(btnID).removeClass("selectedButton");
        $(btnID).addClass("unselectedButton");
    }
}

function selectButton(buttonID) {
    var btnID = "#" + buttonID;
    $(btnID).removeClass("unselectedButton");
    $(btnID).removeClass("rolloverButton");
    $(btnID).addClass("selectedButton");
}

function enableDisablePageNumberBox(enable){
    if(enable){
        $("#pageNumber").addClass("activeTextBox");
        $("#pageNumber").removeClass("inactiveTextBox");
        $("#pageNumber").removeAttr("readonly");
    }
    else{       
        $("#pageNumber").removeClass("activeTextBox");
        $("#pageNumber").addClass("inactiveTextBox");
        $("#pageNumber").attr("readonly", "readonly");
    }
}

function onClickSpreadButton() {
    deselectButton("documentButton");
    selectButton("spreadButton");
}

function onClickDocumentButton() {
    deselectButton("spreadButton");
    selectButton("documentButton");
}

function  LogUIEvent(UIElement) {
    var csInterface = new CSInterface();
    var event = new CSEvent("HTMLPreview", "APPLICATION");
    event.extensionId = csInterface.getExtensionID();    
    event.data = "UIEvent:" + UIElement;
    csInterface.dispatchEvent(event);
}

function LogPreview(IsSpread, Success) {
    var csInterface = new CSInterface();
    var event = new CSEvent("HTMLPreview", "APPLICATION");
    event.extensionId = csInterface.getExtensionID();    
    event.data = "[Group]:" + "PanelUI:" + "Preview:";
    
    if(IsSpread == true)
        event.data += "Mode=Spread:";
    else
        event.data += "Mode=Document:";

    if(Success == true)
        event.data += "Export=Success:"
    else
        event.data += "Export=Failure:"
        
    var w = parseInt($("#previewFrameContainer").width());
    var h = parseInt($("#previewFrameContainer").height());
    event.data += "FrameArea=" + (w*h) + ":";
    
    csInterface.dispatchEvent(event);
} 
